-- =====================================================================================================
-- Script du 20/02/2023 - SGBD cible : MariaDb
-- > Le jeu de caractères utilisé est utf8.
-- =====================================================================================================
set names 'utf8';
-- ----------------------------------------------------------------------------------------------
create table famille(fCode VARCHAR(3) not null,fLibelle VARCHAR(83),primary key(fCode));
-- 
create table medicament(mDepotLegal VARCHAR(10) not null,mNomCommercial VARCHAR(25),mComposition VARCHAR(255),mEffets VARCHAR(255),mContreIndications VARCHAR(255),mPrix FLOAT,fCode VARCHAR(3) not null,primary key(mDepotLegal)) ;
-- 
create table observation(oNum INT not null,pNum INT not null,mDepotLegal VARCHAR(10) not null,oRemarque VARCHAR(128),oDate DATETIME,primary key(oNum)) ;
-- 
create table praticien(pNum INT not null,pNom VARCHAR(25),pPrenom VARCHAR(30),pRue VARCHAR(50),pCP VARCHAR(5),pVille VARCHAR(32),pCoefNotoriete FLOAT,region SMALLINT,tCode VARCHAR(2) not null,primary key(pNum)) ;
-- 
create table region(rCode SMALLINT not null,sCode VARCHAR(1) not null,rNom VARCHAR(50),primary key(rCode)) ;
-- 
create table secteur(sCode VARCHAR(1) not null,sLibelle VARCHAR(15),primary key(sCode));
-- 
create table type_praticien(tCode VARCHAR(2) not null,tLibelle VARCHAR(31),tLieu VARCHAR(31),primary key(tCode)) ;
-- 
-- ----------------------------------------------------------------------------------------------
-- 
insert into famille(fCode,fLibelle) values
     ('AA','Antalgique en association'),
     ('AAA','Antalgique antipyrétiques en association'),
     ('AAC','Antidépresseur d''action centrale'),
     ('AAH','Antivertigineux antihistaminique H1'),
     ('ABA','Antibiotique antituberculeux'),
     ('ABC','Antibiotique antiacnéique local'),
     ('ABP','Antibiotique de la famille des béta-lactamines pénicilline A'),
     ('AFC','Antibiotique de la famille des cyclines'),
     ('AFM','Antibiotique de la famille des macrolides'),
     ('AH','Antihistaminique H1 local'),
     ('AIM','Antidépresseur imipraminique tricyclique'),
     ('AIN','Antidépresseur inhibiteur sélectif de la recapture de la sérotonine'),
     ('ALO','Antibiotique local ORL'),
     ('ANS','Antidépresseur IMAO non sélectif'),
     ('AO','Antibiotique ophtalmique'),
     ('AP','Antipsychotique normothymique'),
     ('AUM','Antibiotique urinaire minute'),
     ('CRT','Corticoïde, Antibiotique et antifongique à  usage local'),
     ('HYP','Hypnotique Antihistaminique'),
     ('PSA','Psychostimulant, Antiasthénique');
-- ----------------------------------------------------------------------------------------------
insert into medicament(mDepotLegal,mNomCommercial,mComposition,mEffets,mContreIndications,mPrix,fCode) values
     ('3MYC7','TRIMYCINE','Triamcinolone (acétonide) + Néomycine + Nystatine','Ce médicament est un corticoïde à  activité forte ou très forte associé à  un antibiotique et un antifongique, utilisé en application locale dans certaines atteintes cutanées surinfectées.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants, d''infections de la peau ou de parasitisme non traités, d''acné. Ne pas appliquer sur une plaie, ni sous un pansement occlusif.',null,'CRT'),
     ('ADIMOL9','ADIMOL','Amoxicilline + Acide clavulanique','Ce médicament, plus puissant que les pénicillines simples, est utilisé pour traiter des infections bactériennes spécifiques.','Ce médicament est contre-indiqué en cas d''allergie aux pénicillines ou aux céphalosporines.',null,'ABP'),
     ('AMOPIL7','AMOPIL','Amoxicilline','Ce médicament, plus puissant que les pénicillines simples, est utilisé pour traiter des infections bactériennes spécifiques.','Ce médicament est contre-indiqué en cas d''allergie aux pénicillines. Il doit être administré avec prudence en cas d''allergie aux céphalosporines.',null,'ABP'),
     ('AMOX45','AMOXAR','Amoxicilline','Ce médicament, plus puissant que les pénicillines simples, est utilisé pour traiter des infections bactériennes spécifiques.','La prise de ce médicament peut rendre positifs les tests de dépistage du dopage.',null,'ABP'),
     ('AMOXIG12','AMOXI Gé','Amoxicilline','Ce médicament, plus puissant que les pénicillines simples, est utilisé pour traiter des infections bactériennes spécifiques.','Ce médicament est contre-indiqué en cas d''allergie aux pénicillines. Il doit être administré avec prudence en cas d''allergie aux céphalosporines.',null,'ABP'),
     ('APATOUX22','APATOUX Vitamine C','Tyrothricine + Tétracaïne + Acide ascorbique (Vitamine C)','Ce médicament est utilisé pour traiter les affections de la bouche et de la gorge.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants, en cas de phénylcétonurie et chez l''enfant de moins de 6 ans.',null,'ALO'),
     ('BACTIG10','BACTIGEL','Erythromycine','Ce médicament est utilisé en application locale pour traiter l''acné et les infections cutanées bactériennes associées.','Ce médicament est contre-indiqué en cas d''allergie aux antibiotiques de la famille des macrolides ou des lincosanides.',null,'ABC'),
     ('BACTIV13','BACTIVIL','Erythromycine','Ce médicament est utilisé pour traiter des infections bactériennes spécifiques.','Ce médicament est contre-indiqué en cas d''allergie aux macrolides (dont le chef de file est l''érythromycine).',null,'AFM'),
     ('BITALV','BIVALIC','Dextropropoxyphène + Paracétamol','Ce médicament est utilisé pour traiter les douleurs d''intensité modérée ou intense.','Ce médicament est contre-indiqué en cas d''allergie aux médicaments de cette famille, d''insuffisance hépatique ou d''insuffisance rénale.',null,'AAA'),
     ('CARTION6','CARTION','Acide acétylsalicylique (aspirine) + Acide ascorbique (Vitamine C) + Paracétamol','Ce médicament est utilisé dans le traitement symptomatique de la douleur ou de la fièvre.','Ce médicament est contre-indiqué en cas de troubles de la coagulation (tendances aux hémorragies), d''ulcère gastroduodénal, maladies graves du foie.',null,'AAA'),
     ('CLAZER6','CLAZER','Clarithromycine','Ce médicament est utilisé pour traiter des infections bactériennes spécifiques. Il est également utilisé dans le traitement de l''ulcère gastro-duodénal, en association avec d''autres médicaments.','Ce médicament est contre-indiqué en cas d''allergie aux macrolides (dont le chef de file est l''érythromycine).',null,'AFM'),
     ('DEPRIL9','DEPRAMIL','Clomipramine','Ce médicament est utilisé pour traiter les épisodes dépressifs sévères, certaines douleurs rebelles, les troubles obsessionnels compulsifs et certaines énurésies chez l''enfant.','Ce médicament est contre-indiqué en cas de glaucome ou d''adénome de la prostate, d''infarctus récent, ou si vous avez reà§u un traitement par IMAO durant les 2 semaines précédentes ou en cas d''allergie aux antidépresseurs imipraminiques.',null,'AIM'),
     ('DIMIRTAM6','DIMIRTAM','Mirtazapine','Ce médicament est utilisé pour traiter les épisodes dépressifs sévères.','La prise de ce produit est contre-indiquée en cas de d''allergie à  l''un des constituants.',null,'AAC'),
     ('DOLRIL7','DOLORIL','Acide acétylsalicylique (aspirine) + Acide ascorbique (Vitamine C) + Paracétamol','Ce médicament est utilisé dans le traitement symptomatique de la douleur ou de la fièvre.','Ce médicament est contre-indiqué en cas d''allergie au paracétamol ou aux salicylates.',null,'AAA'),
     ('DORNOM8','NORMADOR','Doxylamine','Ce médicament est utilisé pour traiter l''insomnie chez l''adulte.','Ce médicament est contre-indiqué en cas de glaucome, de certains troubles urinaires (rétention urinaire) et chez l''enfant de moins de 15 ans.',null,'HYP'),
     ('EQUILARX6','EQUILAR','Méclozine','Ce médicament est utilisé pour traiter les vertiges et pour prévenir le mal des transports.','Ce médicament ne doit pas être utilisé en cas d''allergie au produit, en cas de glaucome ou de rétention urinaire.',null,'AAH'),
     ('EVILR7','EVEILLOR','Adrafinil','Ce médicament est utilisé pour traiter les troubles de la vigilance et certains symptomes neurologiques chez le sujet agé.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants.',null,'PSA'),
     ('INSXT5','INSECTIL','Diphénydramine','Ce médicament est utilisé en application locale sur les piqûres d''insecte et l''urticaire.','Ce médicament est contre-indiqué en cas d''allergie aux antihistaminiques.',null,'AH'),
     ('JOVAI8','JOVENIL','Josamycine','Ce médicament est utilisé pour traiter des infections bactériennes spécifiques.','Ce médicament est contre-indiqué en cas d''allergie aux macrolides (dont le chef de file est l''érythromycine).',null,'AFM'),
     ('LIDOXY23','LIDOXYTRACINE','Oxytétracycline +Lidocaïne','Ce médicament est utilisé en injection intramusculaire pour traiter certaines infections spécifiques.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants. Il ne doit pas être associé aux rétinoïdes.',null,'AFC'),
     ('LITHOR12','LITHORINE','Lithium','Ce médicament est indiqué dans la prévention des psychoses maniaco-dépressives ou pour traiter les états maniaques.','Ce médicament ne doit pas être utilisé si vous êtes allergique au lithium. Avant de prendre ce traitement, signalez à  votre médecin traitant si vous souffrez d''insuffisance rénale, ou si vous avez un régime sans sel.',null,'AP'),
     ('PARMOL16','PARMOCODEINE','Codéine + Paracétamol','Ce médicament est utilisé pour le traitement des douleurs lorsque des antalgiques simples ne sont pas assez efficaces.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants, chez l''enfant de moins de 15 Kg, en cas d''insuffisance hépatique ou respiratoire, d''asthme, de phénylcétonurie et chez la femme qui allaite.',null,'AA'),
     ('PHYSOI8','PHYSICOR','Sulbutiamine','Ce médicament est utilisé pour traiter les baisses d''activité physique ou psychique, souvent dans un contexte de dépression.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants.',null,'PSA'),
     ('PIRIZ8','PIRIZAN','Pyrazinamide','Ce médicament est utilisé, en association à  d''autres antibiotiques, pour traiter la tuberculose.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants, d''insuffisance rénale ou hépatique, d''hyperuricémie ou de porphyrie.',null,'ABA'),
     ('POMDI20','POMADINE','Bacitracine','Ce médicament est utilisé pour traiter les infections oculaires de la surface de l''oeil.','Ce médicament est contre-indiqué en cas d''allergie aux antibiotiques appliqués localement.',null,'AO'),
     ('TROXT21','TROXADET','Paroxétine','Ce médicament est utilisé pour traiter la dépression et les troubles obsessionnels compulsifs. Il peut également être utilisé en prévention des crises de panique avec ou sans agoraphobie.','Ce médicament est contre-indiqué en cas d''allergie au produit.',null,'AIN'),
     ('TXISOL22','TOUXISOL Vitamine C','Tyrothricine + Acide ascorbique (Vitamine C)','Ce médicament est utilisé pour traiter les affections de la bouche et de la gorge.','Ce médicament est contre-indiqué en cas d''allergie à  l''un des constituants et chez l''enfant de moins de 6 ans.',null,'ALO'),
     ('URIEG6','URIREGUL','Fosfomycine trométamol','Ce médicament est utilisé pour traiter les infections urinaires simples chez la femme de moins de 65 ans.','La prise de ce médicament est contre-indiquée en cas d''allergie à  l''un des constituants et d''insuffisance rénale.',null,'AUM');
-- ----------------------------------------------------------------------------------------------
insert into observation(oNum,pNum,mDepotLegal,oRemarque,oDate) values
     (186,3,'EQUILARX6','bla bla bla','2022-10-20'),
     (187,56,'EVILR7','bla bla bla','2022-10-20'),
     (188,13,'DOLRIL7','bla bla bla','2022-10-20'),
     (189,59,'ADIMOL9','bla bla bla bla bla bla','2022-10-22'),
     (190,54,'BITALV','bla bla bla','2022-10-22'),
     (191,70,'LITHOR12','bla bla bla','2022-10-22'),
     (192,75,'3MYC7','bla bla bla','2022-10-25'),
     (193,74,'APATOUX22','bla bla bla','2022-10-26'),
     (194,62,'EVILR7','bla bla bla','2022-10-27'),
     (195,58,'DIMIRTAM6','bla bla bla','2022-10-27'),
     (196,75,'EVILR7','bla bla bla','2022-10-28'),
     (197,2,'BITALV','bla bla bla','2022-10-28'),
     (198,68,'CARTION6','bla bla bla','2022-10-29'),
     (199,7,'BACTIG10','bla bla bla','2022-10-30'),
     (200,66,'TROXT21','bla bla bla','2022-10-30'),
     (201,62,'POMDI20','bla bla bla','2022-10-30'),
     (202,18,'AMOPIL7','bla bla bla','2022-10-31'),
     (203,79,'DOLRIL7','bla bla bla','2022-10-31'),
     (204,4,'POMDI20','bla bla bla','2022-11-2'),
     (205,56,'TROXT21','bla bla bla','2022-11-3'),
     (206,35,'LITHOR12','bla bla bla','2022-11-4'),
     (207,41,'JOVAI8','bla bla bla','2022-10-18'),
     (208,23,'PARMOL16','bla bla bla','2022-11-13'),
     (209,4,'DORNOM8','bla bla bla','2022-12-16'),
     (1,57,'AMOXIG12','pas d''effets secondaires observé','2022-7-29'),
     (2,9,'AMOPIL7','prise en 2 fois par jour efficace','2022-7-30'),
     (3,67,'PHYSOI8','bla bla bla','2022-7-30'),
     (4,80,'TXISOL22','bla bla bla','2022-7-30'),
     (5,68,'TROXT21','bla bla bla','2022-7-31'),
     (6,42,'DIMIRTAM6','bla bla bla','2022-7-31'),
     (7,39,'DORNOM8','bla bla bla','2022-8-1'),
     (8,70,'CARTION6','bla bla bla','2022-8-1'),
     (9,80,'POMDI20','bla bla bla','2022-8-2'),
     (10,53,'BITALV','bla bla bla','2022-8-2'),
     (11,82,'DIMIRTAM6','bla bla bla','2022-8-2'),
     (12,74,'AMOPIL7','allergies fréquentes …','2022-8-4'),
     (13,43,'DEPRIL9','bla bla bla','2022-8-4'),
     (14,69,'ADIMOL9','démangeaisons ou urticaire, enflure au visage, aux lèvres ou à la langue','2022-8-4'),
     (15,78,'3MYC7','bla bla bla bla bla bla','2022-8-4'),
     (16,19,'INSXT5','bla bla bla','2022-8-6'),
     (17,59,'AMOX45','bla bla bla','2022-8-6'),
     (18,5,'CLAZER6','bla bla bla','2022-8-6'),
     (19,81,'EQUILARX6','bla bla bla','2022-8-6'),
     (20,10,'EVILR7','bla bla bla','2022-8-7'),
     (21,10,'DEPRIL9','bla bla bla','2022-8-7'),
     (22,9,'INSXT5','bla bla bla','2022-8-8'),
     (23,65,'ADIMOL9','bla bla bla bla bla bla bla bla bla bla bla bla','2022-8-8'),
     (24,81,'PIRIZ8','bla bla bla','2022-8-8'),
     (25,23,'AMOXIG12','bla bla bla','2022-8-9'),
     (26,23,'BACTIV13','bla bla bla','2022-8-9'),
     (27,2,'BACTIV13','bla bla bla','2022-8-9'),
     (28,45,'CLAZER6','bla bla bla','2022-8-10'),
     (29,49,'AMOX45','bla bla bla','2022-8-11'),
     (30,50,'DIMIRTAM6','bla bla bla','2022-8-11'),
     (31,8,'DEPRIL9','bla bla bla','2022-8-12'),
     (32,77,'EVILR7','bla bla bla','2022-8-12'),
     (33,34,'AMOX45','bla bla bla','2022-8-12'),
     (34,21,'APATOUX22','bla bla bla','2022-8-12'),
     (35,33,'DEPRIL9','bla bla bla','2022-8-12'),
     (36,58,'INSXT5','bla bla bla','2022-8-13'),
     (37,3,'ADIMOL9','bla bla bla …','2022-8-13'),
     (38,48,'BITALV','bla bla bla','2022-8-13'),
     (39,20,'AMOX45','bla bla bla','2022-8-13'),
     (40,35,'DEPRIL9','bla bla bla','2022-8-13'),
     (41,84,'POMDI20','bla bla bla','2022-8-14'),
     (42,65,'URIEG6','bla bla bla','2022-8-14'),
     (43,79,'ADIMOL9','bla bla blabla bla bla','2022-8-14'),
     (44,44,'PHYSOI8','bla bla bla','2022-8-15'),
     (45,6,'PHYSOI8','bla bla bla','2022-8-15'),
     (46,42,'BITALV','bla bla bla','2022-8-15'),
     (47,61,'AMOPIL7','bla bla blabla bla bla','2022-8-16'),
     (48,29,'LIDOXY23','bla bla bla','2022-8-16'),
     (49,64,'BACTIV13','bla bla bla','2022-8-18'),
     (50,52,'PARMOL16','bla bla bla','2022-8-18'),
     (51,39,'DEPRIL9','bla bla bla','2022-8-18'),
     (52,70,'BACTIG10','bla bla bla','2022-8-18'),
     (53,85,'TXISOL22','bla bla bla','2022-8-19'),
     (54,60,'URIEG6','bla bla bla','2022-8-20'),
     (55,31,'BITALV','bla bla bla','2022-8-20'),
     (56,84,'AMOXIG12','bla bla bla','2022-8-21'),
     (57,69,'CARTION6','bla bla bla','2022-8-21'),
     (58,36,'TROXT21','bla bla bla','2022-8-22'),
     (59,73,'INSXT5','bla bla bla','2022-8-23'),
     (60,25,'PARMOL16','bla bla bla','2022-8-24'),
     (61,4,'BACTIV13','bla bla bla','2022-8-24'),
     (62,24,'3MYC7','bla bla bla','2022-8-26'),
     (63,12,'DIMIRTAM6','bla bla bla','2022-8-26'),
     (64,33,'LITHOR12','bla bla bla','2022-8-26'),
     (65,17,'BACTIG10','bla bla bla','2022-8-27'),
     (66,6,'CLAZER6','bla bla bla','2022-8-27'),
     (67,60,'3MYC7','bla bla blabla bla bla bla bla bla','2022-8-28'),
     (68,78,'JOVAI8','bla bla bla','2022-8-28'),
     (69,71,'PARMOL16','bla bla bla','2022-8-28'),
     (70,55,'BACTIV13','bla bla bla','2022-8-29'),
     (71,5,'BITALV','bla bla bla','2022-8-29'),
     (72,28,'AMOX45','bla bla bla','2022-8-29'),
     (73,57,'DORNOM8','bla bla bla','2022-8-29'),
     (74,76,'PHYSOI8','bla bla bla','2022-8-29'),
     (75,37,'PIRIZ8','bla bla bla','2022-8-30'),
     (76,26,'TXISOL22','bla bla bla','2022-9-1'),
     (77,41,'3MYC7','bla bla bla bla bla bla bla bla bla bla bla bla','2022-9-1'),
     (78,11,'JOVAI8','bla bla bla','2022-9-2'),
     (79,27,'TROXT21','bla bla bla','2022-9-2'),
     (80,69,'TXISOL22','bla bla bla','2022-9-2'),
     (81,84,'LIDOXY23','bla bla bla','2022-9-3'),
     (82,32,'JOVAI8','bla bla bla','2022-9-4'),
     (83,30,'ADIMOL9','bla bla bla','2022-9-4'),
     (84,71,'PHYSOI8','bla bla bla','2022-9-4'),
     (85,7,'PARMOL16','bla bla bla','2022-9-6'),
     (86,36,'DORNOM8','bla bla bla','2022-9-6'),
     (87,46,'TROXT21','bla bla bla','2022-9-6'),
     (88,26,'AMOPIL7','bla bla bla bla bla bla bla bla bla','2022-9-7'),
     (89,86,'EVILR7','bla bla bla','2022-9-7'),
     (90,81,'PHYSOI8','bla bla bla','2022-9-7'),
     (91,65,'POMDI20','bla bla bla','2022-9-7'),
     (92,16,'DOLRIL7','bla bla bla','2022-9-8'),
     (93,15,'BACTIV13','bla bla bla','2022-9-8'),
     (94,50,'BACTIG10','bla bla bla','2022-9-8'),
     (95,62,'TROXT21','bla bla bla','2022-9-9'),
     (96,60,'CARTION6','bla bla bla','2022-9-9'),
     (97,22,'PHYSOI8','bla bla bla','2022-9-11'),
     (98,47,'DOLRIL7','bla bla bla','2022-9-11'),
     (99,53,'DOLRIL7','bla bla bla','2022-9-11'),
     (100,79,'LITHOR12','bla bla bla','2022-9-11'),
     (101,29,'PARMOL16','bla bla bla','2022-9-11'),
     (102,48,'EVILR7','bla bla bla','2022-9-12'),
     (103,46,'LIDOXY23','bla bla bla','2022-9-12'),
     (104,73,'LIDOXY23','bla bla bla','2022-9-13'),
     (105,72,'3MYC7','bla bla bla','2022-9-14'),
     (106,58,'CARTION6','bla bla bla','2022-9-14'),
     (107,52,'APATOUX22','bla bla bla','2022-9-14'),
     (108,45,'POMDI20','bla bla bla','2022-9-14'),
     (109,38,'ADIMOL9','bla bla bla !','2022-9-14'),
     (110,63,'DEPRIL9','bla bla bla','2022-9-15'),
     (111,28,'URIEG6','bla bla bla','2022-9-15'),
     (112,14,'LIDOXY23','bla bla bla','2022-9-15'),
     (113,34,'APATOUX22','bla bla bla','2022-9-16'),
     (114,76,'URIEG6','bla bla bla','2022-9-16'),
     (115,83,'EQUILARX6','bla bla bla','2022-9-17'),
     (116,8,'DOLRIL7','bla bla bla','2022-9-17'),
     (117,54,'EVILR7','bla bla bla','2022-9-17'),
     (118,78,'3MYC7','bla bla bla bla bla bla','2022-9-17'),
     (119,19,'DIMIRTAM6','bla bla bla','2022-9-18'),
     (120,20,'LITHOR12','bla bla bla','2022-9-18'),
     (121,57,'AMOPIL7','bla bla bla','2022-9-19'),
     (122,37,'LITHOR12','bla bla bla','2022-9-20'),
     (123,77,'DEPRIL9','bla bla bla','2022-9-20'),
     (124,85,'URIEG6','bla bla bla','2022-9-20'),
     (125,77,'PARMOL16','bla bla bla','2022-9-20'),
     (126,13,'URIEG6','bla bla bla','2022-9-21'),
     (127,61,'DORNOM8','bla bla bla','2022-9-21'),
     (128,30,'CLAZER6','bla bla bla','2022-9-22'),
     (129,11,'3MYC7','bla bla bla et encore …','2022-9-22'),
     (130,40,'DOLRIL7','bla bla bla','2022-9-23'),
     (131,31,'LITHOR12','bla bla bla','2022-9-23'),
     (132,83,'TXISOL22','bla bla bla','2022-9-23'),
     (133,18,'APATOUX22','bla bla bla','2022-9-24'),
     (134,53,'BACTIV13','bla bla bla','2022-9-24'),
     (135,75,'DIMIRTAM6','bla bla bla','2022-9-25'),
     (136,55,'DOLRIL7','bla bla bla','2022-9-25'),
     (137,72,'TROXT21','bla bla bla','2022-9-27'),
     (138,64,'LITHOR12','bla bla bla','2022-9-27'),
     (139,24,'EVILR7','bla bla bla','2022-9-28'),
     (140,27,'POMDI20','bla bla bla','2022-9-28'),
     (141,51,'CARTION6','bla bla bla','2022-9-28'),
     (142,82,'LITHOR12','bla bla bla','2022-9-29'),
     (143,74,'DIMIRTAM6','bla bla bla','2022-9-29'),
     (144,12,'INSXT5','bla bla bla','2022-9-30'),
     (145,56,'TROXT21','bla bla bla','2022-9-30'),
     (146,17,'ADIMOL9','bla bla bla (au moins)','2022-10-1'),
     (147,66,'AMOXIG12','bla bla bla','2022-10-1'),
     (148,32,'DOLRIL7','bla bla bla','2022-10-2'),
     (149,85,'LIDOXY23','bla bla bla','2022-10-2'),
     (150,67,'AMOPIL7','bla bla bla bla bla bla','2022-10-3'),
     (151,47,'BITALV','bla bla bla','2022-10-3'),
     (152,73,'3MYC7','bla bla bla','2022-10-3'),
     (153,21,'PHYSOI8','bla bla bla','2022-10-4'),
     (154,25,'BACTIG10','bla bla bla','2022-10-5'),
     (155,40,'DEPRIL9','bla bla bla','2022-10-5'),
     (156,54,'BACTIG10','bla bla bla','2022-10-6'),
     (157,44,'PIRIZ8','bla bla bla','2022-10-6'),
     (158,59,'DEPRIL9','bla bla bla','2022-10-6'),
     (159,14,'INSXT5','bla bla bla','2022-10-6'),
     (160,72,'AMOPIL7','bla bla bla ?','2022-10-6'),
     (161,63,'BACTIV13','bla bla bla','2022-10-7'),
     (162,76,'DOLRIL7','bla bla bla','2022-10-7'),
     (163,51,'AMOXIG12','bla bla bla','2022-10-9'),
     (164,63,'LITHOR12','bla bla bla','2022-10-9'),
     (165,67,'DOLRIL7','bla bla bla','2022-10-9'),
     (166,61,'LIDOXY23','bla bla bla','2022-10-10'),
     (167,49,'URIEG6','bla bla bla','2022-10-10'),
     (168,71,'APATOUX22','bla bla bla','2022-10-12'),
     (169,43,'EVILR7','bla bla bla','2022-10-12'),
     (170,55,'AMOXIG12','bla bla bla','2022-10-13'),
     (171,41,'CLAZER6','bla bla bla','2022-10-13'),
     (172,64,'URIEG6','bla bla bla','2022-10-14'),
     (173,16,'DIMIRTAM6','bla bla bla','2022-10-14'),
     (174,15,'BACTIG10','bla bla bla','2022-10-14'),
     (175,83,'AMOX45','bla bla bla','2022-10-15'),
     (176,52,'INSXT5','bla bla bla','2022-10-15'),
     (177,66,'EVILR7','bla bla bla','2022-10-15'),
     (178,38,'BITALV','bla bla bla','2022-10-15'),
     (179,86,'DOLRIL7','bla bla bla','2022-10-16'),
     (180,80,'DEPRIL9','bla bla bla','2022-10-16'),
     (181,1,'EQUILARX6','bla bla bla','2022-10-17'),
     (182,1,'TXISOL22','bla bla bla','2022-10-17'),
     (183,68,'ADIMOL9','bla bla bla','2022-10-17'),
     (184,22,'LIDOXY23','bla bla bla','2022-10-20'),
     (185,82,'BITALV','bla bla bla','2022-10-20');
-- ----------------------------------------------------------------------------------------------
insert into praticien(pNum,pNom,pPrenom,pRue,pCP,pVille,pCoefNotoriete,region,tCode) values
     (13,'Morel','Catherine','21 rue Chateaubriand','75000','PARIS',379.57,11,'PS'),
     (31,'Rosenstech','Geneviève','27 rue Auvergne','75000','PARIS',366.82,11,'MH'),
     (46,'Riou','Line','43 bd Gén Vanier','77000','MARNE LA VALLEE',193.25,11,'MH'),
     (53,'Vittorio','Myriam','3 pl Champlain','94000','BOISSY SAINT LEGER',356.23,11,'PS'),
     (57,'Robert','Pascal','31 rue St Jean','93000','BOBIGNY',162.41,11,'MV'),
     (2,'Gosselin','Albert','13 rue Devon','41000','BLOIS',307.49,24,'MV'),
     (14,'Guivarch','Chantal','4 av Gén Laperrine','45000','ORLEANS',114.56,24,'PH'),
     (24,'Goussard','Emmanuel','9 rue Demolombe','41000','BLOIS',40.72,24,'PH'),
     (40,'Dennel','Jean-Louis','7 pl St Gilles','28000','CHARTRES',550.69,24,'PO'),
     (43,'Comoz','Jean-Pierre','35 rue Auguste Lechesne','18000','BOURGES',340.35,24,'PS'),
     (61,'Gandon','Patrick','47 av Robert Schuman','37000','TOURS',599.06,24,'MH'),
     (3,'Delahaye','André','36 av 6 Juin','25000','BESANCON',185.79,27,'PS'),
     (29,'Martin','Frédéric','Bât A 90 rue Bayeux','70000','VESOUL',506.06,27,'PH'),
     (30,'Marie','Frédérique','172 rue Caponière','70000','VESOUL',313.31,27,'PO'),
     (39,'Maury','Jean-François','5 rue Pierre Girard','71000','CHALON SUR SAONE',13.73,27,'PH'),
     (49,'Goessens','Marc','6 av 6 Juin','39000','DOLE',548.57,27,'PH'),
     (52,'Dauverne','Marie-Christine','69 av Charlemagne','21000','DIJON',281.05,27,'MV'),
     (36,'Mosquet','Isabelle','22 rue Jules Verne','76000','ROUEN',77.1,28,'MH'),
     (42,'Chemery','Jean-Pierre','51 pl Ancienne Boucherie','14000','CAEN',396.58,28,'MV'),
     (50,'Laforge','Marc','5 résid Prairie','50000','SAINT LO',265.05,28,'PO'),
     (76,'Leroy','Soazig','45 rue Boutiques','61000','ALENCON',570.67,28,'MH'),
     (78,'Delposen','Sylvain','39 av 6 Juin','27000','DREUX',292.01,28,'PS'),
     (4,'Leroux','André','47 av Robert Schuman','60000','BEAUVAIS',172.04,32,'PH'),
     (6,'Mouel','Anne','27 rue Auvergne','80000','AMIENS',45.2,32,'MH'),
     (10,'Lerat','Bernard','31 rue St Jean','59000','LILLE',257.79,32,'PO'),
     (35,'Leveneur','Hugues','7 pl St Gilles','62000','ARRAS',7.39,32,'PO'),
     (41,'Ain','Jean-Pierre','4 résid Olympia','2000','LAON',5.59,32,'MH'),
     (79,'Rault','Sylvie','15 bd Richemond','2000','SOISSON',526.6,32,'PH'),
     (8,'Marcouiller','Arnaud','31 rue St Jean','68000','MULHOUSE',396.52,44,'PS'),
     (11,'Marçais-Lefebvre','Bertrand','86Bis rue Basse','67000','STRASBOURG',450.96,44,'MH'),
     (12,'Boscher','Bruno','94 rue Falaise','10000','TROYES',356.14,44,'MV'),
     (27,'Lefebvre','Frédéric','2 pl Wurzburg','55000','VERDUN',573.63,44,'MV'),
     (34,'Blanchais','Guy','30 rue Authie','8000','SEDAN',502.48,44,'PH'),
     (48,'Lebrun','Lucette','178 rue Auge','54000','NANCY',410.41,44,'PS'),
     (54,'Lapasset','Nhieu','31 av 6 Juin','52000','CHAUMONT',107,44,'PH'),
     (60,'Lecuirot','Patrice','résid St Pères 55 rue Pigacière','54000','NANCY',239.66,44,'PO'),
     (63,'Boireaux','Philippe','14 av Thiès','10000','CHALON EN CHAMPAGNE',454.48,44,'PS'),
     (71,'Leménager','Pierre','39 av 6 Juin','57000','METZ',118.7,44,'MH'),
     (75,'Mabire','Roland','11 rue Boutiques','67000','STRASBOURG',422.39,44,'PO'),
     (80,'Renouf','Sylvie','98 bd Mar Lyautey','88000','EPINAL',425.24,44,'PO'),
     (1,'Notini','Alain','114 rue Authie','85000','LA ROCHE SUR YON',290.03,52,'MH'),
     (19,'Guenon','Dominique','98 bd Mar Lyautey','44000','NANTES',175.89,52,'PH'),
     (21,'Houchard','Eliane','9 rue Demolombe','49100','ANGERS',436.96,52,'MH'),
     (51,'Millereau','Marc','36 av 6 Juin','72000','LA FERTE BERNARD',430.42,52,'MH'),
     (58,'Jean','Pascale','114 rue Authie','49100','SAUMUR',375.52,52,'PS'),
     (66,'Grigy','Philippe','15 rue Mélingue','44000','CLISSON',285.1,52,'MH'),
     (86,'Laurent','Younès','34 rue Demolombe','53000','MAYENNE',496.1,52,'MH'),
     (7,'Desgranges-Lentz','Antoine','1 rue Albert de Mun','29000','MORLAIX',20.07,53,'MV'),
     (18,'Gaffé','Dominique','9 av 1ère Armée Française','35000','RENNES',213.4,53,'PS'),
     (22,'Desmons','Elisabeth','51 rue Bernières','29000','QUIMPER',281.17,53,'MV'),
     (23,'Flament','Elisabeth','11 rue Pasteur','35000','RENNES',315.6,53,'PS'),
     (28,'Lemée','Frédéric','29 av 6 Juin','56000','VANNES',326.4,53,'PS'),
     (44,'Desfaudais','Jean-Pierre','7 pl St Gilles','29000','BREST',71.76,53,'PH'),
     (20,'Prévot','Dominique','29 rue Lucien Nelle','87000','LIMOGES',151.36,75,'PO'),
     (25,'Desprez','Eric','9 rue Vaucelles','33000','BORDEAUX',406.85,75,'PO'),
     (26,'Coste','Evelyne','29 rue Lucien Nelle','19000','TULLE',441.87,75,'MH'),
     (32,'Pontavice','Ghislaine','8 rue Gaillon','86000','POITIERS',265.58,75,'MV'),
     (33,'Leveneur-Mosquet','Guillaume','47 av Robert Schuman','64000','PAU',184.97,75,'PS'),
     (45,'Phan','JérÃ´me','9 rue Clos Caillet','79000','NIORT',451.61,75,'PO'),
     (47,'Chubilleau','Louis','46 rue Eglise','17000','SAINTES',202.07,75,'MV'),
     (55,'Plantet-Besnier','Nicole','10 av 1ère Armée Française','86000','CHATELLEREAULT',369.94,75,'PO'),
     (69,'Dechâtre','Pierre','63 av Thiès','23000','MONTLUCON',253.75,75,'PH'),
     (70,'Goessens','Pierre','22 rue Jean Romain','40000','MONT DE MARSAN',426.19,75,'PO'),
     (85,'Duchemin-Laniel','Véronique','130 rue St Jean','33000','LIBOURNE',265.61,75,'PO'),
     (5,'Desmoulins','Anne','31 rue St Jean','30000','NIMES',94.75,76,'PO'),
     (9,'Dupuy','Benoit','9 rue Demolombe','34000','MONTPELLIER',395.66,76,'PH'),
     (17,'Cauchy','Denis','5 av Ste Thérèse','11000','NARBONNE',458.82,76,'MV'),
     (64,'Cendrier','Philippe','7 pl St Gilles','12000','RODEZ',164.16,76,'PH'),
     (65,'Duhamel','Philippe','114 rue Authie','34000','MONTPELLIER',98.62,76,'PO'),
     (67,'Linard','Philippe','1 rue Albert de Mun','81000','ALBI',486.3,76,'MV'),
     (68,'Lozier','Philippe','8 rue Gaillon','31000','TOULOUSE',48.4,76,'PS'),
     (72,'Née','Pierre','39 av 6 Juin','82000','MONTAUBAN',72.54,76,'MV'),
     (73,'Guyot','Pierre-Laurent','43 bd Gén Vanier','48000','MENDE',352.31,76,'PS'),
     (77,'Guyot','Stéphane','26 rue Hérouville','46000','FIGEAC',28.85,76,'MV'),
     (84,'Bobichon','Tristan','219 rue Caponière','9000','FOIX',218.36,76,'PH'),
     (37,'Giraudon','Jean-Christophe','1 rue Albert de Mun','38100','VIENNE',92.62,84,'MV'),
     (38,'Marie','Jean-Claude','26 rue Hérouville','69000','LYON',120.1,84,'PS'),
     (56,'Chubilleau','Pascal','3 rue Hastings','15000','AURRILLAC',290.75,84,'MH'),
     (62,'Mirouf','Patrick','22 rue Puits Picard','74000','ANNECY',458.42,84,'MV'),
     (81,'Alliet-Grach','Thierry','14 av Thiès','7000','PRIVAS',451.31,84,'MH'),
     (82,'Bayard','Thierry','92 rue Falaise','42000','SAINT ETIENNE',271.71,84,'MV'),
     (83,'Gauchet','Thierry','7 rue Desmoueux','38100','GRENOBLE',406.1,84,'PS'),
     (15,'Bessin-Grosdoit','Christophe','92 rue Falaise','6000','NICE',222.06,93,'PO'),
     (16,'Rossa','Claire','14 av Thiès','6000','NICE',529.78,93,'MH'),
     (59,'Chanteloube','Patrice','14 av Thiès','13000','MARSEILLE',478.01,93,'PH'),
     (74,'Chauchard','Roger','9 rue Vaucelles','13000','MARSEILLE',552.19,93,'PH');
-- ----------------------------------------------------------------------------------------------
insert into region(rCode,sCode,rNom) values
     (11,'P','ILE-DE-FRANCE'),
     (24,'P','CENTRE-VAL DE LOIRE'),
     (27,'E','BOURGOGNE-FRANCHE-COMTE'),
     (28,'O','NORMANDIE'),
     (32,'N','HAUTS-DE-FRANCE'),
     (44,'E','ALSACE-CHAMPAGNE-ARDENNE-LORRAINE'),
     (52,'O','PAYS DE LA LOIRE'),
     (53,'O','BRETAGNE'),
     (75,'S','AQUITAINE-LIMOUSIN-POITOU-CHARENTES'),
     (76,'S','LANGUEDOC-ROUSSILLON-MIDI-PYRENEES'),
     (84,'E','AUVERGNE-RHONE-ALPES'),
     (93,'S','PROVENCE-ALPES-COTE D''AZUR'),
     (94,'S','CORSE'),
     (1,'P','GUADELOUPE'),
     (2,'P','MARTINIQUE'),
     (3,'P','GUYANE'),
     (4,'P','LA REUNION'),
     (6,'P','MAYOTTE');
-- ----------------------------------------------------------------------------------------------
insert into secteur(sCode,sLibelle) values
     ('E','Est'),
     ('N','Nord'),
     ('O','Ouest'),
     ('P','Paris centre'),
     ('S','Sud');
-- ----------------------------------------------------------------------------------------------
insert into type_praticien(tCode,tLibelle,tLieu) values
     ('MH','Médecin Hospitalier','Hopital ou clinique'),
     ('MV','Médecine de Ville','Cabinet'),
     ('PH','Pharmacien Hospitalier','Hopital ou clinique'),
     ('PO','Pharmacien Officine','Pharmacie'),
     ('PS','Personnel de santé','Centre paramédical');
-- ----------------------------------------------------------------------------------------------
-- contraintes d'intégrité référentielles
alter table medicament add foreign key (fCode) references famille(fCode) on update cascade;
alter table observation add foreign key (mDepotLegal) references medicament(mDepotLegal) on update cascade;
alter table observation add foreign key (pNum) references praticien(pNum) on update cascade;
alter table praticien add foreign key (tCode) references type_praticien(tCode) on update cascade;
alter table region add foreign key (sCode) references secteur(sCode) on update cascade;
alter table praticien add foreign key (region) references region(rCode);
commit;

-- ajout d'une colonne fGroupe dans famille--
ALTER TABLE famille ADD fGroupe CHAR(25);   #création d’une colonne groupe

UPDATE famille #On met toutes les familles de médicaments en autre
SET fGroupe='Autres'
WHERE fLibelle LIKE '%';

UPDATE famille  #On met toutes les familles d’Antalgiques au groupe Antalgique
SET fGroupe= 'Antalgique'
WHERE fLibelle LIKE '%Antalgique%';

UPDATE famille  #On met toutes les familles d’antibiotiques au groupe Antibiotiques
SET fGroupe= 'Antibiotique'
WHERE fLibelle LIKE '%Antibiotique%';

UPDATE famille  #On met toutes les familles d’antidépresseur au groupe Antidépresseur
SET fGroupe= 'Antidépresseur'
WHERE fLibelle LIKE '%Antidépresseur%';
 
UPDATE famille  #On met toutes les familles d’antihistaminique au groupe Antihistaminique
SET fGroupe= 'Antihistaminique'
WHERE fLibelle LIKE '%Antihistaminique%';


-- Ajout d'une table utilisateur

CREATE TABLE utilisateurs 
(
    id INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(50) NOT NULL,
    prenom VARCHAR(50) NOT NULL,
    identifiant VARCHAR(50) NOT NULL UNIQUE,
    mot_de_passe VARCHAR(255) NOT NULL
);

-- Pour ajouter un utilisateur
INSERT INTO utilisateurs (nom, prenom, identifiant, mot_de_passe)
VALUES ('Balducci', 'Dorian', 'balducci.dorian', SHA2('Azerty!1', 256)),
('Gudin', 'Théo', 'gudin.theo', SHA2('Azerty!2', 256));
